# usage: awk -f rd_sdf.awk dsgn_constraints.sdf

# path_constraint = 1 if the "PATHCONSTRAINT" is found in the record
# input_port = 1 if the path_start is the port;
# output_port = 1 if the path_end is the port;
# use instance name instead of pin name on path_end for TSU
# use instance name instead of pin name on path_start and path_end for FMAX
# Note: it handles multiple lines within a pathconstraint

BEGIN {FS= " "; path_constraint = 0;h_divider="/";time_scale=1;curr_spec=0;}
$1 ~ /DIVIDER/ {h_divider= substr($2,1,length($2)-1);}
$1 ~ /TIMESCALE/ {time_scale=substr($2,1,length($2)-3);}
$1 ~ /PATHCONSTRAINT/ {path_constraint=1; continue_line= 0;}
{
  if (path_constraint == 1)
  {
    #printf("NR= %s\n",NR);
    if (continue_line == 0)
    {
        start_path= $2; 
        nmx= split(start_path,nmarray,"\\");
        start_path= nmarray[1];
        for (nmi=2; nmi<=nmx; nmi++)
	{
           start_path= sprintf("%s%s",start_path,nmarray[nmi]);
	   spec_char= substr(nmarray[nmi],1,1);
	   found= 0;
	   if (spec_char != "/") 
	   {
	     for (k=1; k<= curr_spec; k++)
             {
	        if (spec_array[k] == spec_char)
		{
		  found= 1;
		  break;
	    	}
	      }
	     if (found == 0) {spec_array[k]= spec_char; curr_spec= k;}
	   }
 	}
        start_field= 3;
    }
    else { start_field= 1;}

    for (i=start_field;i<=NF;i++) 
    { 
      if (split($i,array,":") > 1) 
      {
        end_path= $(i-1); 
        nmx= split(end_path,nmarray,"\\");
        end_path= nmarray[1];
        for (nmi=2; nmi<=nmx; nmi++)
	{
           end_path= sprintf("%s%s",end_path,nmarray[nmi]);
	   spec_char= substr(nmarray[nmi],1,1);
	   found= 0;
	   if (spec_char != "/") 
	   {
	     for (k=1; k<= curr_spec; k++)
             {
	        if (spec_array[k] == spec_char)
		{
		  found= 1;
		  break;
	    	}
	      }
	     if (found == 0) {spec_array[k]= spec_char; curr_spec= k;}
	   }
 	}
        x=array[1]; 
        dly= substr(x,2);
	delay= dly/time_scale;

        if (split(start_path,array,h_divider) > 1)
           input_port= 0; else {input_port = 1;}
        if (split(end_path,array,h_divider) > 1)
           output_port= 0; else {output_port = 1; }

 	     if (input_port == 1 && output_port == 1)
	     { 
	        cur_tpd=sprintf("%s,%s = %-6.2f\n", start_path,end_path,delay);
 
	        printf("%s\tTPD\t%s %-6.2f\n", end_path,start_path,delay);
      	     }
      	     else 
      	     {
       		 if (input_port == 1 && output_port == 0)
                 {
		    if ((x= split(end_path,ep_ary,h_divider)) > 1 )
            	    {
              	      y= length(ep_ary[x]); 
              	      x= length(end_path); 
              	      ep_name= substr(end_path,1,x-y-1); 
            	    } 
	            printf("%s\tTSU\t%s %-6.2f\n",ep_name, start_path,delay);
 		 }
      	         else
      	         {
 		    if (input_port == 0 && output_port == 1)
	               printf("%s\tTCO\t%s %-6.2f\n", end_path,start_path,delay);
      	            else
      	    	    { 
			if (input_port == 0 && output_port == 0)
                        {
		            if ((x= split(start_path,sp_ary,h_divider)) > 1 )
            		    {
              		      y= length(sp_ary[x]); 
              		      x= length(start_path); 
              		      sp_name= substr(start_path,1,x-y-1); 
            		    } 
		            if ((x= split(end_path,ep_ary,h_divider)) > 1 )
            		    {
              		      y= length(ep_ary[x]); 
              		      x= length(end_path); 
              		      ep_name= substr(end_path,1,x-y-1); 
            		    } 
	                printf("%s\tFMAX\t%s %-6.2f\n", ep_name,sp_name,delay);
                        }
		    }
		  }
       	      } 
       path_constraint= 0; #reset after see the delay and print it
       continue_line= 0;
       break;
       }
     }
  # handle continuation line
  if (path_constraint != 0) {continue_line= 1;}
  }
}
END {
	for (k=1; k<=curr_spec;k++)
	printf("%s\n",spec_array[k]) >> "alt_tmp.spc";
}
